package shapes;

public class ShapesDemo {

    public static void main(String[] args) {
        new ShapesDemo().run();
    }

    private void run() {
        // Zasada podstawienia Liskov — implementujemy interfejs Graphics bez niespodzianek.
        Graphics console = new ConsoleGraphics();

        // Zasada odwrócenia zależności — wstrzykujemy obiekt Graphics jako zależność do obiektu Shapes.
        var shapes = new Shapes(console);

        // Zasada otwarte-zamknięte — klasa Shapes przyjmuje dowolną podklasę typu Shape.
        // Zasada jednej odpowiedzialności — każda podklasa (np. Rectangle) wie, jak narysować jeden kształt.
        // Zasada podstawienia Liskov — każdej podklasy można użyć tam, gdzie oczekiwany jest interfejs Shape.
        shapes.add(new TextBox("Witaj w pokazie zastosowania zasad SOLID na przykładzie rysowania kształtów"));
        shapes.add(new Rectangle(32,1));
        shapes.add(new TextBox("Stosujemy zasady SOLID do tworzenia rozszerzalnych miniframeworków."));
        shapes.add(new TextBox("Rysujemy kształty złożone ze znaków ASCI."));
        shapes.add(new TextBox("Poniżej prostokąt o wymiarach 5 x 3:"));
        shapes.add(new Rectangle(5,3));

        // Podejście „mów, nie pytaj”: kształty wiedzą, co mają robić — niech same się narysują.
        shapes.draw();
    }
}
