package com.wordz.domain;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.when;

@ExtendWith(MockitoExtension.class)
public class WordSelectionTest {

    private static final int HIGHEST_WORD_NUMBER = 3;
    private static final int SELECTED_WORD_NUMBER = 2;
	
    @Mock
    private WordRepository repository;

    @Mock
    private RandomNumbers random;

    @BeforeEach
    void beforeEachTest() {
        when(repository.highestWordNumber()).thenReturn(HIGHEST_WORD_NUMBER);

        when(repository.fetchWordByNumber(SELECTED_WORD_NUMBER)).thenReturn("BLASK");
    }

    @Test
    void selectsWordAtRandom() {
        when(random.next(HIGHEST_WORD_NUMBER)).thenReturn(SELECTED_WORD_NUMBER);
        var selector = new WordSelection(repository, random);

        String actual = selector.chooseRandomWord();

        assertThat(actual).isEqualTo("BLASK");
    }
}
