
/**
 * Zależności modułu.
 */

var qs = require('querystring')
  , https = require('https')

/**
 * klucz dostępowy aplikacji do API twittera
 */

var auth = '...'

/**
 * Funkcja search.
 *
 * @param {String} search query
 * @param {Function} callback
 * @api public
 */

module.exports = function search (query, fn) {
  https.request({
    host: 'api.twitter.com',
    path: '/1.1/search/tweets.json?' + qs.stringify({ q: query }),
    headers: { 'Authorization': 'Bearer ' + auth }
  }, function (res) {
    res.setEncoding('utf8');

    var body = '';

    res.on('data', function (chunk) {
      body += chunk;
    });

    res.on('end', function () {
      try {
        var obj = JSON.parse(body);
      } catch (e) {
        return fn(new Error('Nieprawidłowa odpowiedź twittera'));
      }

      fn(null, obj.statuses);
    });
  }).end()
};
