
/**
 * Zależności modułu.
 */

var express = require('express')
  , Sequelize = require('sequelize')

/**
 * Utwórz aplikację.
 */

app = express.createServer();

/**
 * Utwórz instancję Sequelize.
 */

var sequelize = new Sequelize('todo-example')

/**
 * Zdefiniuj model projektu.
 */

var Project = sequelize.define('Project', {
    title: sequelize.STRING
  , description: sequelize.TEXT
  , created: sequelize.DATE
});

/**
 * Zdefiniuj model zadania.
 */

var Task = sequelize.define('Task', {
    title: sequelize.STRING
});

/**
 * Ustaw powiązanie.
 */

Task.belongsTo(Project);

/**
 * Synchronizuj.
 */

sequelize.sync({ force: 'production' != process.env.NODE_ENV });

/**
 * Skonfiguruj aplikację.
 */

app.set('view engine', 'jade');
app.set('views', __dirname + '/views');

/**
 * Trasa główna
 */

app.get('/', function (req, res, next) {
  res.render('index');
});

/**
 * Trasa usuwania projektu.
 */

app.del('/project/:id', function (req, res, next) {
});

/**
 * Trasa tworzenia projektu.
 */

app.post('/projects', function (req, res, next) {
});

/**
 * Pokaż zadania dla projektu.
 */

app.get('/project/:id/items', function (req, res, next) {
});

/**
 * Dodaj zadanie do projektu.
 */

app.post('/project/:id/items', function (req, res, next) {
});

/**
 * Trasa zadania.
 */

app.del('/item/:id', function (req, res, next) {
});
/**
 * Nasłuchuj.
 */

app.listen(3000, function () {
  console.log(' - nasłuchję na http://*:3000');
});
