var express = require('express')
  , wsio = require('websocket.io')
  , http = require('http')

/**
 * Utwórz aplikację Express.
 */

var app = express();
var server = http.createServer(app);

/**
 * Przyłącz serwer WebSocket.
 */

var ws = wsio.attach(server);

/**
 * Obsłuż kod
 */

app.use(express.static('public'))

/**
 * Nasłuchiwanie połączeń
 */

ws.on('connection', function (socket) {
  socket.on('message', function (msg) {
    socket.send(msg);
  });
});

/**
 * Nasłuchuj
 */

server.listen(3000);
