
/**
 * Zależności modułu.
 */

var express = require('express')
  , Sequelize = require('sequelize')

/**
 * Utwórz aplikację.
 */

app = express.createServer();

/**
 * Utwórz instancję Sequelize.
 */

var sequelize = new Sequelize('todo-example', 'root')

/**
 * Zdefiniuj model projektu.
 */

var Project = sequelize.define('Project', {
    title: Sequelize.STRING
  , description: Sequelize.TEXT
  , created: Sequelize.DATE
});

/**
 * Zdefiniuj model zadania.
 */

var Task = sequelize.define('Task', {
    title: Sequelize.STRING
});

/**
 * Ustaw powiązanie.
 */

Task.belongsTo(Project);
Project.hasMany(Task);

/**
 * Synchronizuj.
 */

sequelize.sync();

/**
 * Skonfiguruj aplikację.
 */

app.set('view engine', 'jade');
app.set('view options', { layout: false });
app.set('views', __dirname + '/views');

/**
 * Metody pośredniczące
 */

app.use(express.static(__dirname + '/public')); 
app.use(express.bodyParser());

/**
 * Trasa główna
 */

app.get('/', function (req, res, next) {
  Project.findAll()
    .success(function (projects) {
      res.render('index', { projects: projects });
    })
    .error(next);
});

/**
 * Trasa usuwania projektu.
 */

app.del('/project/:id', function (req, res, next) {
  Project.find(Number(req.params.id)).success(function (proj) {
    proj.destroy()
      .success(function () {
        res.send(200);
      })
      .error(next);
  }).error(next);
});

/**
 * Trasa tworzenia projektu.
 */

app.post('/projects', function (req, res, next) {
  Project.build(req.body).save()
    .success(function (obj) {
       res.send(obj.values);
     })
    .error(next)
});

/**
 * Pokaż zadania dla projektu.
 */

app.get('/project/:id/tasks', function (req, res, next) {
  Project.find(Number(req.params.id))
    .success(function (project) {
      project.getTasks().on('success', function (tasks) {
        res.render('tasks', { project: project, tasks: tasks });
      })
    })
    .error(next)
});

/**
 * Dodaj zadanie do projektu.
 */

app.post('/project/:id/tasks', function (req, res, next) {
  req.body.ProjectId = req.params.id;
  Task.build(req.body).save()
    .success(function (obj) {
       res.send(obj.values);
     })
    .error(next)
});

/**
 * Trasa zadania.
 */

app.del('/task/:id', function (req, res, next) {
  Task.find(Number(req.params.id)).success(function (task) {
    task.destroy()
      .success(function () {
        res.send(200);
      })
      .error(next)
  }).error(next);
});

/**
 * Nasłuchuj.
 */

app.listen(3000, function () {
  console.log(' - nasłuchję na http://*:3000');
});
