/**
 * Zależności modułu.
 */

var express = require('express')
  , sio = require('socket.io')
  , http = require('http')
  , request = require('superagent')

/**
 * Utwórz aplikację.
 */

app = express();

app.use(express.bodyParser());
app.use(express.static('public'));

/**
 * Serwer.
 */

var server = http.createServer(app);

/**
 * Nasłuchuj.
 */

server.listen(3000);

var io = sio.listen(server)
  , apiKey = 'cc78b550effeea0edb929ada1e9d0729'
  , currentSong
  , dj

function elect (socket) {
  dj = socket;
  io.sockets.emit('announcement', socket.nickname + ' jest nowym dj-em');
  socket.emit('elected');
  socket.dj = true;
  socket.on('disconnect', function () {
    dj = null;
    io.sockets.emit('announcement', 'dj odszedł – następny nowy będzie dj-em');
  });
}

io.sockets.on('connection', function (socket) {
  socket.on('join', function (name) {
    socket.nickname = name;
    socket.broadcast.emit('announcement', name + ' dołączył do czata.');
    if (!dj) {
      elect(socket);
    } else {
      socket.emit('song', currentSong);
    }
  });

  socket.on('search', function (q, fn) {
    request('http://tinysong.com/s/' + encodeURIComponent(q)
      + '?key=' + apiKey + '&format=json', function (res) {
      if (200 == res.status) fn(JSON.parse(res.text));
    });
  });

  socket.on('song', function (song) {
    if (socket.dj) {
      currentSong = song;
      socket.broadcast.emit('song', song);
    }
  });

  socket.on('text', function (msg) {
    socket.broadcast.emit('text', socket.nickname, msg);
  });
});
