
/**
 * Zależności modułu.
 */

var connect = require('connect')
  , time = require('./request-time')

/**
 * Utwórz serwer.
 */

var server = connect.createServer();

/**
 * Zapisz żądania w pliku dziennika.
 */

server.use(connect.logger('dev'));

/**
 * Implementacja metody pośredniczącej.
 */

server.use(time({ time: 500 }));

/**
 * Szybka odpowiedź.
 */

server.use(function (req, res, next) {
  if ('/a' == req.url) {
    res.writeHead(200, {'Content-Type': 'text/html; charset=utf-8'});
    res.end('Krótko!');
  } else {
    next();
  }
});


/**
 * Wolna odpowiedź.
 */

server.use(function (req, res, next) {
  if ('/b' == req.url) {
    setTimeout(function () {
      res.writeHead(200, {'Content-Type': 'text/html; charset=utf-8'});
      res.end('Długo!');
    }, 1000);
  } else {
    next();
  }
});

/**
 * Nasłuchuj.
 */

server.listen(3000);
