
var qs = require('querystring');

require('http').createServer(function (req, res) {
  if ('/' == req.url) {
    res.writeHead(200, { 'Content-Type': 'text/html; charset=utf-8' });
    res.end([
        '<form method="POST" action="/url">'
      ,   '<h1>Mój formularz</h1>'
      ,   '<fieldset>'
      ,   '<label>Dane użytkownika</label>'
      ,   '<p>Jak masz na imię?</p>'
      ,   '<input type="text" name="name">'
      ,   '<p><button>Wyślij</button></p>'
      , '</form>'
    ].join(''));
  } else if ('/url' == req.url && 'POST' == req.method) {
    var body = '';

    req.on('data', function (chunk) {
      body += chunk;
    });

    req.on('end', function () {
      res.writeHead(200, { 'Content-Type': 'text/html; charset=utf-8' });
      res.end('<p>Twoje imię to <b>' + qs.parse(body).name + '</b></p>');
    });
  } else {
    res.writeHead(404);
    res.end('Nie znaleziono');
  }
}).listen(3000);
