
/**
 * Zależności modułu
 */

var connect = require('connect')
  , users = require('./users')

/**
 * Utwórz serwer
 */

var server = connect(
    connect.logger('dev')
  , connect.bodyParser()
  , connect.cookieParser()
  , connect.session({ secret: 'mój klucz' })
  , function (req, res, next) {
      if ('/' == req.url && req.session.logged_in) {
        res.writeHead(200, { 'Content-Type': 'text/html' });
        res.end(
            'Witaj z powrotem, <b>' + req.session.name + '</b>. '
          + '<a href="/logout">Wyloguj</a>'
        );
      } else {
        next();
      }
    }
  , function (req, res, next) {
      if ('/' == req.url && 'GET' == req.method) {
        res.writeHead(200, { 'Content-Type': 'text/html; charset=utf-8' });
        res.end([
            '<form action="/login" method="POST">'
          ,   '<fieldset>'
          ,     '<legend>Zaloguj się</legend>'
          ,     '<p>Użytkownik: <input type="text" name="user"></p>'
          ,     '<p>Hasło: <input type="password" name="password"></p>'
          ,     '<button>Wyślij</button>'
          ,   '</fieldset>'
          , '</form>'
        ].join(''));
      } else {
        next();
      }
    }
  , function (req, res, next) {
      if ('/login' == req.url && 'POST' == req.method) {
        res.writeHead(200, { 'Content-Type': 'text/html; charset=utf-8' } );
        if (!users[req.body.user] || req.body.password != users[req.body.user].password) {
          res.end('Zła nazwa użytkownika lub hasło');
        } else {
          req.session.logged_in = true;
          req.session.name = users[req.body.user].name;
          res.end('Zalogowano pomyślnie!');
        }
      } else {
        next();
      }
    }
  , function (req, res, next) {
      if ('/logout' == req.url) {
        req.session.logged_in = false;
        res.writeHead(200);
        res.end('Wylogowano!');
      } else {
        next();
      }
    }
);

/**
 * Nasłuchuj.
 */

server.listen(3000);
