
/**
 * Zależności modułu.
 */

var fs = require('fs');

fs.readdir(__dirname, function (err, files) {
  console.log('');

  if (!files.length) {
    return console.log('    \033[31m Brak plików do wyświetlenia!\033[39m\n');
  }

  console.log('   Wybierz plik lub katalog, który chcesz zobaczyć\n');

  function file(i) {
    var filename = files[i];

    fs.stat(__dirname + '/' + filename, function (err, stat) {
      if (stat.isDirectory()) {
        console.log('     '+i+'   \033[36m' + filename + '/\033[39m');
      } else {
        console.log('     '+i+'   \033[90m' + filename + '\033[39m');
      }

      if (++i == files.length) {
        console.log('');
        process.stdout.write('   \033[33mWprowadź swój wybór: \033[39m');
        process.stdin.resume();
        process.stdin.setEncoding('utf8');
      } else {
        file(i);
      }
    });
  }

  file(0);

});
