
/**
 * Zależności modułu.
 */

var express = require('express')
  , mongodb = require('mongodb')

/**
 * Konfiguracja aplikacji.
 */

app = express.createServer()

/**
 * Metody pośredniczące.
 */

app.use(express.bodyParser());
app.use(express.cookieParser());
app.use(express.session({ secret: 'moj sekret' }));

/**
 * Określ opcje widoku.
 */

app.set('view engine', 'jade');
app.set('view options', { layout: false });

/**
 * Metody pośredniczące do uwierzytelnienia.
 */

app.use(function (req, res, next) {
  if (req.session.loggedIn) {
    res.local('authenticated', true);
    app.users.findOne({ _id: mongodb.ObjectID.createFromHexString(req.session.loggedIn) }, function (err, doc) {
      if (err) return next(err);
      res.local('me', doc);
      next();
    });
  } else {
    res.local('authenticated', false);
    next();
  }
});

/**
 * Domyślna trasa
 */

app.get('/', function (req, res) {
  res.render('index');
});

/**
 * Trasa logowania
 */

app.get('/login/:signupEmail?', function (req, res) {
  res.render('login', { signupEmail: req.params.signupEmail });
});

/**
 * Trasa przetwarzania logowania
 */

app.post('/login', function (req, res) {
  app.users.findOne(req.body.user, function (err, doc) {
    if (err) return next(err);
    if (!doc) return res.send('<p>Nie znaleziono użytkownika. Wróć do poprzedniej strony i spróbuj ponownie.');
    req.session.loggedIn = doc._id.toString();
    res.redirect('/');
  });
});

/**
 * Trasa rejestracji
 */

app.get('/signup', function (req, res) {
  res.render('signup');
});

/**
 * Trasa przetwarzania rejestracji
 */

app.post('/signup', function (req, res, next) {
  app.users.insert(req.body.user, function (err, doc) {
    if (err) return next(err);
    res.redirect('/login/' + doc[0].email);
  });
});

/**
 * Trasa wylogowywania.
 */

app.get('/logout', function (req, res) {
  req.session.loggedIn = null;
  res.redirect('/');
});

/**
 * Połącz się z bazą danych.
 */

var server = new mongodb.Server('127.0.0.1', 27017)
new mongodb.Db('my-website', server).open(function (err, client) {
  // nie pozwól na uruchomienie aplikacji, jeśli pojawił się błąd
  if (err) throw err;

  console.log('\033[96m  + \033[39m połączono z mongodb');

  // ustaw skróty do kolekcji
  app.users = new mongodb.Collection(client, 'users');

  client.ensureIndex('users', 'email', function (err) {
    if (err) throw err;
    client.ensureIndex('users', 'password', function (err) {
      if (err) throw err;

      console.log('\033[96m  + \033[39m indeksy zapewnione');

      // nasłuchuj
      app.listen(3000, function () {
        console.log('\033[96m  + \033[39m aplikacja nasłuchuje na porcie *:3000');
      });
    });
  });
});
