var util = require('util');
var express = require('express');
var path = require('path');
var favicon = require('serve-favicon');
var logger = require('morgan');
var cookieParser = require('cookie-parser');
var bodyParser = require('body-parser');

var routes = require('./routes/index');
// var users = require('./routes/users');
var notes  = require('./routes/notes');

var app = express();

// Konfigurowanie silnika widoków
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'ejs');

//  Przenieś kod poza komentarz po umieszczeniu pliku favicon.ico w katalogu /public
//app.use(favicon(path.join(__dirname, 'public', 'favicon.ico')));
app.use(logger('dev'));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));

app.use('/', routes);
// app.use('/users', users);
app.use('/notes', notes);

// Przechwytywanie błędu 404 i przekazywanie go do funkcji obsługi błędów
app.use(function(req, res, next) {
  var err = new Error('Nie znaleziono');
  err.status = 404;
  next(err);
});

// Funkcje obsługi błędów

// Funkcja obsługi błędów dla środowiska programistycznego.
// Wyświetla stos błędów
if (app.get('env') === 'development') {
  app.use(function(err, req, res, next) {
    util.log(err.message);
    res.status(err.status || 500);
    res.render('error', {
      message: err.message,
      error: err
    });
  });
}

// Funkcja obsługi błędów dla środowiska produkcyjnego.
// Nie ujawnia użytkownikom stosu błędów
app.use(function(err, req, res, next) {
  util.log(err.message);
  res.status(err.status || 500);
  res.render('error', {
    message: err.message,
    error: {}
  });
});


module.exports = app;
