
var notes = 'http://localhost:3000';

casper.test.begin('Można zalogować się do aplikacji Notes', function suite(test) {
    casper.start(notes, function() {
        test.assertTitle("Notes");
        test.assertExists('a#btnloginlocal', "Znaleziono przycisk Zaloguj");
        this.click("a#btnloginlocal");
    });
    
    casper.then(function() {
        test.assertHttpStatus(200);
        test.assertUrlMatch(/users\/login/, 'Oczekiwany adres to: /users/login');
        this.fill('form', {
            username: "me",
            password: "w0rd"
        });
        this.click('button[type="submit"]');
    });
    
    casper.waitForSelector('#btnlogout', function() {
        // this.echo('Zalogowany?');
        test.assertHttpStatus(200);
        test.assertTitle("Notes");
        test.assertExists('a#btnlogout', "Znaleziono przycisk wylogowywania");
        test.assertExists('a#btnaddnote', "Znaleziono przycisk Dodaj notatkę");
        this.click("#btnaddnote");
    });
    
    casper.waitForUrl(/notes\/add/, function() {
        test.assertHttpStatus(200);
        test.assertTitle("Dodawanie notatki");
        test.assertField("docreate", "create");
        this.fill('form', {
            notekey: 'testkey',
            title: 'Tytuł testowej notatki',
            body: 'Treść testowej notatki z tekstowymi atrakcjami'
        });
        this.click('button[type="submit"]');
    });
    
    casper.waitForUrl(/notes\/view/, function() {
        test.assertHttpStatus(200);
        test.assertTitle("Tytuł testowej notatki");
        test.assertSelectorHasText("p#notebody", 'Treść testowej notatki z tekstowymi atrakcjami');
        this.click('#btndestroynote');
    });
    
    casper.waitForUrl(/notes\/destroy/, function() {
        test.assertHttpStatus(200);
        test.assertTitle("Tytuł testowej notatki");
        test.assertField("notekey", "testkey");
        this.click('input[type="submit"]');
    });
    
    casper.waitForUrl(notes, function() {
        test.assertHttpStatus(200);
        test.assertTitle("Notes");
        test.assertExists('a#btnlogout', "Znaleziono przycisk wylogowywania");
        this.click("#btnlogout");
    });
    
    casper.waitForUrl(notes, function() {
        test.assertHttpStatus(200);
        test.assertTitle("Notes");
        test.assertExists('a#btnloginlocal', "Znaleziono przycisk logowania");
    });

    casper.run(function() {
        test.done();
    });
});