'use strict';

const assert = require('chai').assert;

const model = require(process.env.MODEL_TO_TEST);

describe("Testy modelu", function() {
    
    beforeEach(function() {
        return model.keylist()
        .then(keyz => {
            var todel = keyz.map(key => model.destroy(key)); 
            return Promise.all(todel);
        })
        .then(() => {
            return Promise.all([
                model.create("n1", "Notatka nr 1", "Notatka nr 1"),
                model.create("n2", "Notatka nr 2", "Notatka nr 2"),
                model.create("n3", "Notatka nr 3", "Notatka nr 3")
            ]);
        });
    });
    
    describe("Sprawdzanie listy kluczy", function() {
        it("Powinny pojawić się trzy wpisy", function() {
            return model.keylist()
            .then(keyz => {
                assert.equal(3, keyz.length, "Trzy elementy");
            });
        });
        it("Powinny pojawić się klucze n1 n2 n3", function() {
            return model.keylist()
            .then(keyz => {
                keyz.forEach(key => {
                    assert.match(key, /n[123]/, "Poprawny klucz");
                });
            });
        });
        it("Tytuły powinny mieć postać Notatka nr", function() {
            return model.keylist()
            .then(keyz => {
                var keyPromises = keyz.map(key => model.read(key));
                return Promise.all(keyPromises);
            })
            .then(notez => {
                notez.forEach(note => {
                    assert.match(note.title, /Notatka nr [123]/, "Poprawny tytuł");
                });
            });
        });
    });
    
    describe("Wczytywanie notatki", function() {
        it("Notatka powinna mieć poprawną postać", function() {
            return model.read("n1")
            .then(note => {
                assert.equal(note.key, "n1");
                assert.equal(note.title, "Notatka nr 1");
                assert.equal(note.body, "Notatka nr 1");
            });
        });
        
        it("Dla nieistniejących notatek oczekiwane jest niepowodzenie", function() {
            return model.read("zlyklucz12")
            .then(note => {
                throw new Error("Kod nie powinien dojść do tego miejsca");
            })
            .catch(err => {
                // To oczekiwane działanie, dlatego nie należy sygnalizować błędu
            });
        })
    });
    
    describe("Modyfikowanie notatki", function() {
        it("Po udanym wywołaniu model.update", function() {
            return model.update("n1", "Nowy tytuł notatki nr 1", "Nowa treść notatki nr 1")
            .then(newnote => {
                return model.read("n1");
            })
            .then(newnote => {
                assert.equal(newnote.key, "n1");
                assert.equal(newnote.title, "Nowy tytuł notatki nr 1");
                assert.equal(newnote.body, "Nowa treść notatki nr 1");    
            });
        })
    });
    
    describe("Usuwanie notatki", function() {
        it("Notatka powinna zostać usunięta", function() {
            return model.destroy("n1")
            .then(() => {
                return model.keylist()
                .then(keyz => {
                    assert.equal(2, keyz.length, "Liczba notatek to 2");
                });
            })
        });
        it("Dla nieistniejących notatek oczekiwane jest niepowodzenie", function() {
            return model.destroy("zlyklucz12")
            .then(() => {
                throw new Error("Kod nie powinien dojść do tego miejsca");
            })
            .catch(err => {
                // To oczekiwane działanie, dlatego nie należy sygnalizować błędu
            });
        })
    });
});
