'use strict';

const restify = require('restify');
const util    = require('util');

const log   = require('debug')('users:server');
const error = require('debug')('users:error');

const usersModel = require('./users-sequelize');

var server = restify.createServer({
    name: "User-Auth-Service",
    version: "0.0.1"
});

server.use(restify.authorizationParser());
server.use(check);
server.use(restify.queryParser());
server.use(restify.bodyParser({
    mapParams: true
}));

// Tworzenie rekordu z danymi użytkownika
server.post('/create-user', (req, res, next) => {
    usersModel.create(req.params.username, req.params.password,  req.params.provider,
                      req.params.familyName, req.params.givenName, req.params.middleName,
                      req.params.emails,   req.params.photos)
    .then(result => {
        // log('utworzono '+ util.inspect(result));
        res.send(result);
        next(false);
    })
    .catch(err => { res.send(500, err); error(err.stack); next(false); });
});

// Aktualizowanie rekordu istniejącego użytkownika
server.post('/update-user/:username', (req, res, next) => {
    usersModel.update(req.params.username, req.params.password,  req.params.provider,
                      req.params.familyName, req.params.givenName, req.params.middleName,
                      req.params.emails,   req.params.photos)
    .then(foo => {
        // log('zaktualizowano '+ util.inspect(result));
        res.send(result);
        next(false);
    })
    .catch(err => { res.send(500, err); error(err.stack); next(false); });
});

// Wyszukiwanie użytkownika. Po niepowodzeniu tworzenie użytkownika na podstawie informacji z profilu
server.post('/find-or-create', (req, res, next) => {
    log('find-or-create '+ util.inspect(req.params));
    usersModel.findOrCreate({
        id: req.params.username, username: req.params.username,
        password: req.params.password, provider: req.params.provider,
        familyName: req.params.familyName, givenName: req.params.givenName,
        middleName: req.params.middleName,
        emails: req.params.emails, photos: req.params.photos
    })
    .then(result => {
        // log('utworzono '+ util.inspect(result));
        res.send(result);
        next(false);
    })
    .catch(err => { res.send(500, err); error(err.stack); next(false); });
});

// Wyszukiwanie danych użytkownika (nie zwraca hasła)
server.get('/find/:username', (req, res, next) => {
    usersModel.find(req.params.username).then(user => {
        if (!user) {
            res.send(404, new Error("Nie znaleziono "+ req.params.username));
        } else {
            res.send(user);
        }
        next(false);
    })
    .catch(err => { res.send(500, err); error(err.stack); next(false); });
});

// Sprawdzanie, czy użytkownik istnieje
server.get('/exists/:username', (req, res, next) => {
    usersModel.find(req.params.username).then(user => {
        if (!user) {
            res.send({ exists: false, username, message: "Nie znaleziono "+ req.params.username });
        } else {
            res.send({ exists: true, username });
        }
        next(false);
    })
    .catch(err => {
        res.send(500, { exists: false, username, message: err.stack });
        error(err.stack);
        next(false);
    });
});

// Usuwanie rekordu użytkownika
server.del('/destroy/:username', (req, res, next) => {
    usersModel.destroy(req.params.username)
    .then(() => res.send({}) )
    .catch(err => { res.send(500, err); error(err.stack); next(false); });
});

// Sprawdzanie hasła
server.post('/passwordCheck', (req, res, next) => {
    usersModel.userPasswordCheck(req.params.username, req.params.password)
    .then(check => { res.send(check); next(false); })
    .catch(err => { res.send(500, err); error(err.stack); next(false); });
});

// Wyświetlanie użytkowników
server.get('/list', (req, res, next) => {
    usersModel.listUsers().then(userlist => {
        if (!userlist) userlist = [];
        log(util.inspect(userlist));
        res.send(userlist);
        next(false);
    })
    .catch(err => { res.send(500, err); error(err.stack); next(false); });
});

server.listen(process.env.PORT, "localhost", function() {
  log(server.name +' oczekuje na żądania pod adresem '+ server.url);
});

// Symulowanie uwierzytelniania z użyciem klucza API.

var apiKeys = [ { user: 'them', key: 'D4ED43C0-8BD6-4FE2-B358-7C0E230D11EF' } ];

function check(req, res, next) {
    if (req.authorization) {
        var found = false;
        for (let auth of apiKeys) {
            if (auth.key  === req.authorization.basic.password
             && auth.user === req.authorization.basic.username) {
                found = true;
                break;
            }
        }
        if (found) next();
        else {
            res.send(401, new Error("Brak uwierzytelnienia"));
            error('Nieudane uwierzytelnianie '+ util.inspect(req.authorization));
            next(false);
        }
    } else {
        res.send(500, new Error('Brak klucza autoryzacji'));
        error('BRAK AUTORYZACJI');
        next(false);
    }
}
