'use strict';

const util    = require('util');
const sqlite3 = require('sqlite3');

const log     = require('debug')('notes:sqlite3-model');
const error   = require('debug')('notes:error');

const Note    = require('./Note');

sqlite3.verbose();
var db; // Tu zapisywane jest połączenie z bazą

exports.connectDB = function() {
    return new Promise((resolve, reject) => {
        if (db) return resolve(db);
        var dbfile = process.env.SQLITE_FILE || "notes.sqlite3";
        db = new sqlite3.Database(dbfile,
            sqlite3.OPEN_READWRITE | sqlite3.OPEN_CREATE,
            err => {
                if (err) reject(err);
                else {
                    log('Otwarto bazę SQLite3 '+ dbfile);
                    resolve(db);
                }
            });
    });
};

exports.create = function(key, title, body) {
    return exports.connectDB().then(() => {
        var note = new Note(key, title, body);
        return new Promise((resolve, reject) => {
            db.run("INSERT INTO notes ( notekey, title, body) "+
                "VALUES ( ?, ? , ? );",
                [ key, title, body ], err => {
                    if (err) reject(err);
                    else {
                        log('TWORZENIE '+ util.inspect(note));
                        resolve(note);
                    }
            });
        });
    });
};

exports.update = function(key, title, body) {
    return exports.connectDB().then(() => {
        var note = new Note(key, title, body);
        return new Promise((resolve, reject) => {
            db.run("UPDATE notes "+
                "SET  title = ?, body = ? "+
                "WHERE notekey = ?",
                [ title, body, key ], err => {
                    if (err) reject(err);
                    else {
                        log('AKTUALIZOWANIE '+ util.inspect(note));
                        resolve(note);
                    }
            });
        });
    });
};

exports.read = function(key) {
    return exports.connectDB().then(() => {
        return new Promise((resolve, reject) => {
            db.get("SELECT * FROM notes WHERE notekey = ?",
                [ key ], (err, row) => {
                if (err) reject(err);
				// Naprawiono błąd z poprzednich rozdziałów
                else if (!row) {
                    reject(new Error("Nie znaleziono notatki dla klucza " + key));
                } else {
                    var note = new Note(row.notekey, row.title, row.body);
                    log('WCZYTYWANIE '+ util.inspect(note));
                    resolve(note);
                }
            });
        });
    });
};

exports.destroy = function(key) {
    return exports.connectDB().then(() => {
        return new Promise((resolve, reject) => {
            db.run("DELETE FROM notes WHERE notekey = ?;",
                [ key ], err => {
                if (err) reject(err);
                else {
                    log('USUWANIE '+ key);
                    resolve();
                }
            });
        });
    });
};

exports.keylist = function() {
    return exports.connectDB().then(() => {
        return new Promise((resolve, reject) => {
            var keyz = [];
            db.each("SELECT notekey FROM notes",
                (err, row) => {
                    if (err) reject(err);
                    else keyz.push(row.notekey);
                },
                (err, num) => {
                    if (err) reject(err);
                    else {
                        log('KEYLIST '+ num +' '+ util.inspect(keyz));
                        resolve(keyz);
                    }
                });
        });
    });
};

exports.count = function() {
    return exports.connectDB().then(() => {
        return new Promise((resolve, reject) => {
            db.get("select count(notekey) as count from notes",
                (err, row) => {
                    if (err) return reject(err);
                    log('ZLICZANIE '+ util.inspect(row));
                    resolve(row.count);
                });
        });
    });
};
