// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.CascadingDropDown
{
    /// <summary>
    /// Specific CascadingDropDown scenarios
    /// </summary>
    public partial class Specific : Page
    {
        [System.Web.Services.WebMethod]
        [System.Web.Script.Services.ScriptMethod]
        public static AjaxControlToolkit.CascadingDropDownNameValue[] GetDropDownContents_PageMethod(string knownCategoryValues, string category)
        {
            AjaxControlToolkit.CascadingDropDownNameValue[] values = new CarsService().GetDropDownContents(knownCategoryValues, category);
            if (1 < values.Length)
            {
                values[1].isDefaultValue = true;
            }
            return values;
        }

        [System.Web.Services.WebMethod]
        [System.Web.Script.Services.ScriptMethod]
        public static AjaxControlToolkit.CascadingDropDownNameValue[] GetDropDownContents_ContextKey_PageMethod(string knownCategoryValues, string category, string contextKey)
        {
            return new CascadingDropDownNameValue[] { new CascadingDropDownNameValue(contextKey + "-Name", contextKey + "-Value") };
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            Label.Text = string.Join(":", new string[] { DropDownList.SelectedValue, DropDownList.SelectedItem.Value, DropDownList.SelectedItem.Text });
            LabelSelectedValue.Text = string.Join(":", new string[] { DropDownListSelectedValue.SelectedValue, DropDownListSelectedValue.SelectedItem.Value, DropDownListSelectedValue.SelectedItem.Text });
            LabelLoadingTextPromptText.Text = string.Join(":", new string[] { DropDownListLoadingTextPromptText.SelectedValue, DropDownListLoadingTextPromptText.SelectedItem.Value, DropDownListLoadingTextPromptText.SelectedItem.Text });
        }
    }
}
