// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// WriteStrategy defines how cached BehaviorProperty instances are
    /// synchronized with their corresponding client-side behaviors on update
    /// </summary>
    public enum WriteStrategy
    {
        /// <summary>
        /// Immediately update the property by forcing a synchronization
        /// with the client-side behavior
        /// </summary>
        Immediate = 0,

        /// <summary>
        /// Update the property as part of the next synchronization with
        /// the client-side behavior
        /// </summary>
        NextSynchronization = 1
    }
}