// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using System.Web.UI.WebControls;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.SliderExtender Model
    /// </summary>
    /// <TestComponent Name="Slider">
    ///   <ToolkitType>AjaxControlToolkit.SliderExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.Slider.Slider_Common</CommonTestSuite>
    /// </TestComponent>
    public class SliderBehavior : Behavior<HtmlInputElement>
    {
        /// <summary>
        /// Minimum
        /// </summary>
        public BehaviorProperty<double> Minimum
        {
            get { return _minimum; }
        }
        private BehaviorProperty<double> _minimum;

        /// <summary>
        /// Maximum
        /// </summary>
        public BehaviorProperty<double> Maximum
        {
            get { return _maximum; }
        }
        private BehaviorProperty<double> _maximum;

        /// <summary>
        /// RailCssClass
        /// </summary>
        public BehaviorProperty<string> RailCssClass
        {
            get { return _railCssClass; }
        }
        private BehaviorProperty<string> _railCssClass;

        /// <summary>
        /// HandleImageUrl
        /// </summary>
        public BehaviorProperty<string> HandleImageUrl
        {
            get { return _handleImageUrl; }
        }
        private BehaviorProperty<string> _handleImageUrl;

        /// <summary>
        /// HandleCssClass
        /// </summary>
        public BehaviorProperty<string> HandleCssClass
        {
            get { return _handleCssClass; }
        }
        private BehaviorProperty<string> _handleCssClass;

        /// <summary>
        /// EnableHandleAnimation
        /// </summary>
        public BehaviorProperty<bool> EnableHandleAnimation
        {
            get { return _enableHandleAnimation; }
        }
        private BehaviorProperty<bool> _enableHandleAnimation;

        /// <summary>
        /// Steps
        /// </summary>
        public BehaviorProperty<int> Steps
        {
            get { return _steps; }
        }
        private BehaviorProperty<int> _steps;

        /// <summary>
        /// Orientation
        /// </summary>
        public BehaviorProperty<SliderOrientation> Orientation
        {
            get { return _orientation; }
        }
        private BehaviorProperty<SliderOrientation> _orientation;

        /// <summary>
        /// Decimals
        /// </summary>
        public BehaviorProperty<int> Decimals
        {
            get { return _decimals; }
        }
        private BehaviorProperty<int> _decimals;

        /// <summary>
        /// BoundControlID
        /// </summary>
        public ReferenceBehaviorProperty<HtmlInputElement> BoundControl
        {
            get { return _boundControl; }
        }
        private ReferenceBehaviorProperty<HtmlInputElement> _boundControl;

        /// <summary>
        /// Length
        /// </summary>
        public BehaviorProperty<Unit> Length
        {
            get { return _length; }
        }
        private BehaviorProperty<Unit> _length;

        /// <summary>
        /// RaiseChangeOnlyOnMouseUp
        /// </summary>
        public BehaviorProperty<bool> RaiseChangeOnlyOnMouseUp
        {
            get { return _raiseChangeOnlyOnMouseUp; }
        }
        private BehaviorProperty<bool> _raiseChangeOnlyOnMouseUp;

        /// <summary>
        /// TooltipText
        /// </summary>
        public BehaviorProperty<string> TooltipText
        {
            get { return _tooltipText; }
        }
        private BehaviorProperty<string> _tooltipText;

        /// <summary>
        /// ImageHandleElement
        /// </summary>
        public ReferenceBehaviorProperty<HtmlImageElement> ImageHandleElement
        {
            get { return _imageHandleElement; }
        }
        private ReferenceBehaviorProperty<HtmlImageElement> _imageHandleElement;

        /// <summary>
        /// ImageHandleElement
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> RailElement
        {
            get { return _railElement; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _railElement;


        public BehaviorProperty<double> SliderValue
        {
            get { return this._value; }
        }
        private BehaviorProperty<double> _value;
        /// <summary>
        /// AjaxControlToolkit.SliderExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public SliderBehavior(HtmlInputElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _minimum = BehaviorProperty<double>.CreateProperty(this, "Minimum");
            _maximum = BehaviorProperty<double>.CreateProperty(this, "Maximum");
            _railCssClass = BehaviorProperty<string>.CreateProperty(this, "RailCssClass");
            _handleImageUrl = BehaviorProperty<string>.CreateProperty(this, "HandleImageUrl");
            _handleCssClass = BehaviorProperty<string>.CreateProperty(this, "HandleCssClass");
            _enableHandleAnimation = BehaviorProperty<bool>.CreateProperty(this, "EnableHandleAnimation");
            _steps = BehaviorProperty<int>.CreateProperty(this, "Steps");
            _orientation = BehaviorProperty<SliderOrientation>.CreateProperty(this, "Orientation");
            _decimals = BehaviorProperty<int>.CreateProperty(this, "Decimals");
            _boundControl = ReferenceBehaviorProperty<HtmlInputElement>.CreateProperty(this, "BoundControlID");
            _length = BehaviorProperty<Unit>.CreateProperty(this, "Length", 
                delegate(object obj) 
                { 
                    string length = (obj == null)? "0px" : obj.ToString();
                    return Unit.Parse(length);
                });
            _raiseChangeOnlyOnMouseUp = BehaviorProperty<bool>.CreateProperty(this, "RaiseChangeOnlyOnMouseUp");
            _tooltipText = BehaviorProperty<string>.CreateProperty(this, "TooltipText");
            _imageHandleElement = ReferenceBehaviorProperty<HtmlImageElement>.CreateField(this, "id", "{0}._handleImage");
            _railElement = ReferenceBehaviorProperty<HtmlElement>.CreateField(this, "id", "{0}._railElement");
            _value = BehaviorProperty<double>.CreateProperty(this, "Value");
        }

        /// <summary>
        /// validate slider handle image 
        /// </summary>
        public void AssertHandleImage()
        {
            Assert.StringContains(this.ImageHandleElement.Reference.GetAttributes().Source, this.HandleImageUrl.Value);
        }

        /// <summary>
        /// validate that the slider state is correct
        /// </summary>
        /// <param name="expectedSliderValue"></param>
        public void AssertSliderValue(double expectedSliderValue)
        {
            this.SliderValue.Invalidate();
            double currentVal = this.SliderValue.Value;
            ToolkitAssert.All(
                    delegate() { Assert.AreEqual(expectedSliderValue, currentVal); },
                    delegate() { Assert.IsTrue(currentVal <= this.Maximum.Value); },
                    delegate() { Assert.IsTrue(currentVal >= this.Minimum.Value); },
                    delegate() 
                    { 
                        Assert.AreEqual(currentVal, double.Parse(this.Element.GetAttributes().Value)); 
                    },
                    delegate()
                    {
                        if (this.BoundControl.Reference != null)
                        {
                            Assert.AreEqual(expectedSliderValue, this.BoundControlValue);
                        }
                    });
        }

        public double BoundControlValue
        {
            get
            {
                return double.Parse(this.BoundControl.Reference.GetAttributes().Value.Trim());
            }
            set
            {
                this.BoundControl.Reference.SetText(value.ToString());
            }
        }
    }
}