// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Web.UI.WebControls;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.RoundedCornersExtender Model
    /// </summary>
    /// <TestComponent Name="RoundedCorners">
    ///   <ToolkitType>AjaxControlToolkit.RoundedCornersExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.RoundedCorners.RoundedCorners_Common</CommonTestSuite>
    /// </TestComponent>
    public class RoundedCornersBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// Radius
        /// </summary>
        public BehaviorProperty<int> Radius
        {
            get { return _radius; }
        }
        private BehaviorProperty<int> _radius;

        /// <summary>
        /// Corners
        /// </summary>
        public BehaviorProperty<BoxCorners> Corners
        {
            get { return _corners; }
        }
        private BehaviorProperty<BoxCorners> _corners;

        /// <summary>
        /// Color
        /// </summary>
        public ColorProperty Color
        {
            get { return _color; }
        }
        private ColorProperty _color;

        /// <summary>
        /// BorderColor
        /// </summary>
        public ColorProperty BorderColor
        {
            get { return _borderColor; }
        }
        private ColorProperty _borderColor;

        /// <summary>
        /// AjaxControlToolkit.RoundedCornersExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public RoundedCornersBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _radius = BehaviorProperty<int>.CreateProperty(this, "Radius");
            _corners = BehaviorProperty<BoxCorners>.CreateProperty(this, "Corners");
            _color = new ColorProperty(this, "Color", ClientMemberType.Property, ReadStrategy.DemandAndInitialize, WriteStrategy.Immediate, null, null, null, null);
            _borderColor = new ColorProperty(this, "BorderColor", ClientMemberType.Property, ReadStrategy.DemandAndInitialize, WriteStrategy.Immediate, null, null, null, null);
        }
    }
}