// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.PopupControlExtender Model
    /// </summary>
    /// <TestComponent Name="PopupControl">
    ///   <ToolkitType>AjaxControlToolkit.PopupControlExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.PopupControl.PopupControl_Common</CommonTestSuite>
    /// </TestComponent>
    public class PopupControlBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// PopupControl
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> PopupControl
        {
            get { return _popupControl; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _popupControl;

        /// <summary>
        /// CommitProperty
        /// </summary>
        public BehaviorProperty<string> CommitProperty
        {
            get { return _commitProperty; }
        }
        private BehaviorProperty<string> _commitProperty;

        /// <summary>
        /// CommitScript
        /// </summary>
        public BehaviorProperty<string> CommitScript
        {
            get { return _commitScript; }
        }
        private BehaviorProperty<string> _commitScript;

        /// <summary>
        /// Position
        /// </summary>
        public BehaviorProperty<PopupControlPopupPosition> Position
        {
            get { return _position; }
        }
        private BehaviorProperty<PopupControlPopupPosition> _position;

        /// <summary>
        /// OffsetX
        /// </summary>
        public BehaviorProperty<int> OffsetX
        {
            get { return _offsetX; }
        }
        private BehaviorProperty<int> _offsetX;

        /// <summary>
        /// OffsetY
        /// </summary>
        public BehaviorProperty<int> OffsetY
        {
            get { return _offsetY; }
        }
        private BehaviorProperty<int> _offsetY;

        /// <summary>
        /// DynamicControl
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> DynamicControl
        {
            get { return _dynamicControl; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _dynamicControl;

        /// <summary>
        /// DynamicContextKey
        /// </summary>
        public BehaviorProperty<string> DynamicContextKey
        {
            get { return _dynamicContextKey; }
        }
        private BehaviorProperty<string> _dynamicContextKey;

        /// <summary>
        /// DynamicServicePath
        /// </summary>
        public BehaviorProperty<string> DynamicServicePath
        {
            get { return _dynamicServicePath; }
        }
        private BehaviorProperty<string> _dynamicServicePath;

        /// <summary>
        /// DynamicServiceMethod
        /// </summary>
        public BehaviorProperty<string> DynamicServiceMethod
        {
            get { return _dynamicServiceMethod; }
        }
        private BehaviorProperty<string> _dynamicServiceMethod;

        /// <summary>
        /// CacheDynamicResults
        /// </summary>
        public BehaviorProperty<bool> CacheDynamicResults
        {
            get { return _cacheDynamicResults; }
        }
        private BehaviorProperty<bool> _cacheDynamicResults;

        /// <summary>
        /// PopupBehavior
        /// </summary>
        public PopupBehavior PopupBehavior
        {
            get 
            {
                if (_popupBehavior == null)
                {
                    _popupBehavior = new PopupBehavior(
                        _popupControl.Reference,
                        BehaviorID + "_popupBehavior",
                        string.Format("{0}._popupBehavior", this.BehaviorReferenceExpression),
                        Page);
                }
                return _popupBehavior; 
            }
        }
        private PopupBehavior _popupBehavior;

        /// <summary>
        /// AjaxControlToolkit.PopupControlExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public PopupControlBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _popupControl = ReferenceBehaviorProperty<HtmlElement>.CreateProperty(this, "PopupControlID");
            _commitProperty = BehaviorProperty<string>.CreateProperty(this, "CommitProperty");
            _commitScript = BehaviorProperty<string>.CreateProperty(this, "CommitScript");
            _position = BehaviorProperty<PopupControlPopupPosition>.CreateProperty(this, "Position");
            _offsetX = BehaviorProperty<int>.CreateProperty(this, "OffsetX");
            _offsetY = BehaviorProperty<int>.CreateProperty(this, "OffsetY");
            _dynamicControl = ReferenceBehaviorProperty<HtmlElement>.CreateProperty(this, "dynamicControlID");
            _dynamicContextKey = BehaviorProperty<string>.CreateProperty(this, "dynamicContextKey");
            _dynamicServicePath = BehaviorProperty<string>.CreateProperty(this, "dynamicServicePath");
            _dynamicServiceMethod = BehaviorProperty<string>.CreateProperty(this, "dynamicServiceMethod");
            _cacheDynamicResults = BehaviorProperty<bool>.CreateProperty(this, "cacheDynamicResults");
        }
    }
}