// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.PasswordStrength;

/// <summary>
/// Test to make sure that entering a valid/invalid password in the textbox results in
/// the right behavior in the password strength extender.
/// </summary>
/// <TestSuite>
///   <Path>PasswordStrength\TextIndicatorValidInvalidPassword.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.PasswordStrengthBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.PasswordStrength.TextIndicatorValidInvalidPasswordPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("PasswordStrength.TextIndicatorValidInvalidPassword")]
public class PasswordStrength_TextIndicatorValidInvalidPassword : AjaxControlToolkit.Testing.Client.PasswordStrength.PasswordStrength_Common
{
    public override IEnumerable<PasswordStrengthBehavior> PasswordStrengths
    {
        get
        {
            yield return new TextIndicatorValidInvalidPasswordPage().p1;
        }
    }
}