// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;

namespace AjaxControlToolkit.Testing.Client.MultiHandleSlider
{
    /// <summary>
    /// Common MultiHandleSlider tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.MultiHandleSliderBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("MultiHandleSlider")]
    public abstract class MultiHandleSlider_Common
    {
        public abstract IEnumerable<MultiHandleSliderBehavior> BackCompatSliders
        {
            get;
        }

        [WebTestMethod]
        [WebTestTag("Smoke")]
        public void Common_AssertSliderRangesValue()
        {
            foreach (MultiHandleSliderBehavior slider in BackCompatSliders)
            {
                ToolkitAssert.All(
                    delegate
                    {
                        slider.SliderValue.Value = slider.Minimum.Value - 5;;
                        slider.AssertSliderValue(slider.Minimum.Value);
                    },
                    delegate
                    {
                        slider.SliderValue.Value = slider.Maximum.Value + 5;
                        slider.AssertSliderValue(slider.Maximum.Value);
                    },
                    delegate
                    {
                        // Perform Integer division if Decimals is 0.
                        if (slider.Decimals.Value == 0)
                        {
                            int newValue = (int)slider.Minimum.Value + ((int)slider.Maximum.Value - (int)slider.Minimum.Value) / 2;
                            slider.SliderValue.Value = newValue;
                            slider.AssertSliderValue(newValue);
                        }
                        else
                        {
                            double newValue = slider.Minimum.Value + (slider.Maximum.Value - slider.Minimum.Value) / 2;
                            slider.SliderValue.Value = newValue;
                            slider.AssertSliderValue(Math.Round(newValue, slider.Decimals.Value));
                        }
                    });
            }
        }
    }
}
