// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.MaskedEdit;

/// <summary>
/// Verify masked edit extender functionality when mask type is set to none
/// </summary>
/// <TestSuite>
///   <Path>MaskedEdit\NoMask.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.MaskedEditBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.MaskedEdit.NoMaskPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("MaskedEdit.NoMask")]
public class MaskedEdit_NoMask : AjaxControlToolkit.Testing.Client.MaskedEdit.MaskedEdit_Common
{
    public override IEnumerable<MaskedEditScenario> MaskedEdits
    {
        get 
        {
            NoMaskPage page = new NoMaskPage();
            yield return new MaskedEditScenario(page.MaskedEditExtender4, "______________________________", page.MaskedEditValidator4);
        }
    }

    /// <summary>
    /// Check the messages from the validator and the maskededitextender tooltip.
    /// </summary>
    [WebTestMethod]
    [WebTestFailureTag(Browsers.InternetExplorer7, "TODO: ???")]
    public void ValidatorMessages()
    {
        NoMaskPage page = new NoMaskPage();
        Assert.AreEqual(String.Empty, page.MaskedEditValidator4.GetAttributes().InnerText);
        page.TextBox4.Focus();
        page.TextBox4.DispatchEvent(new HtmlMouseEvent("click"));
        Assert.AreEqual("Input Text", page.MaskedEditValidator4.GetAttributes().InnerText);
        page.TextBox4.Blur();
        Assert.AreEqual("Message Empty", page.MaskedEditValidator4.GetAttributes().InnerText);
    }

    /// <summary>
    /// Validate that chars less than min allowed does not work.
    /// </summary>
    [WebTestMethod]
    [WebTestTag("Intermittent")] // TODO: ??? fails intermittently in all browsers
    public void MinimumLimit()
    {
        NoMaskPage page = new NoMaskPage();
        Assert.AreEqual(String.Empty, page.MaskedEditValidator4.GetAttributes().InnerText);

        // minimum char text length
        page.TextBox4.SetText("a");
        page.TextBox4.Blur();
        Assert.AreEqual("a", page.TextBox4.GetAttributes().Value ?? string.Empty);
        Assert.AreEqual("Message Min", page.MaskedEditValidator4.GetAttributes().InnerText);

        page.TextBox4.SetText("abc", true);
        page.TextBox4.Blur();
        Assert.AreEqual("abc", page.TextBox4.GetAttributes().Value ?? string.Empty);
        Assert.AreEqual(string.Empty, page.MaskedEditValidator4.GetAttributes().InnerText);

    }

    /// <summary>
    /// Validate that chars more than max allowed does not work.
    /// </summary>
    [WebTestTag("Intermittent")] // TODO: ??? fails intermittently in all browsers
    [WebTestMethod]
    public void MaximimLimit()
    {
        NoMaskPage page = new NoMaskPage();

        // text length maximum
        page.TextBox4.SetText("abcdefghijabcdefghijabcdefghij", true);
        Assert.AreEqual("abcdefghijabcdefghijabcdefghij", page.TextBox4.GetAttributes().Value ?? string.Empty);
        Assert.AreEqual(String.Empty, page.MaskedEditValidator4.GetAttributes().InnerText);

        // text length greater than limits
        page.TextBox4.SetText("abcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghij");
        Assert.AreEqual("abcdefghijabcdefghijabcdefghij", page.TextBox4.GetAttributes().Value ?? string.Empty);
        Assert.AreEqual(string.Empty, page.MaskedEditValidator4.GetAttributes().InnerText);

    }
}