// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ExtenderBase;

/// <summary>
/// CSS via WebResource Created in Code
/// </summary>
/// <TestSuite>
///   <Path>ExtenderBase\CssWebResourceCreateCode.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ExtenderBaseBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ExtenderBase.CssWebResourceCreateCodePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ExtenderBase.CssWebResourceCreateCode")]
public class ExtenderBase_CssWebResourceCreateCode : AjaxControlToolkit.Testing.Client.ExtenderBase.ExtenderBase_Common
{
    [WebTestMethod]
    public void CssLoaded()
    {
        CssWebResourceCreateCodePage page = new CssWebResourceCreateCodePage();

        // Flip visibility of controls during async postback
        page.RegisterForPartialPostback();
        page.Button.Click();
        page.WaitForPartialPostback();
        // Check Calendar CSS
        Assert.AreEqual("20px", Common.GetCurrentStyle<string>(page.Label, "height"));
        // Check TabContainer CSS (ScriptControlBase)
        Assert.AreEqual("4px", Common.GetCurrentStyle<string>(page.Label, "marginRight"));
    }
}
