
// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.DropDown
{
    /// <summary>
    /// Common DropDown tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.DropDownBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("DropDown")]
    [WebTestTag("Hover")]
    [WebTestTag("Popup")]
    public abstract class DropDown_Common
    {
        public abstract IEnumerable<DropDownBehavior> DropDownBehaviors
        {
            get;
        }

        [WebTestMethod]
        public void Common_InitialState()
        {
            foreach (DropDownBehavior dropDown in DropDownBehaviors)
            {
                dropDown.AssertClosed();
            }
        }

        [WebTestMethod]
        public void Common_Hover()
        {
            foreach (DropDownBehavior dropDown in DropDownBehaviors)
            {
                dropDown.HoverBehavior.HoverOver();
                dropDown.AssertHover();
                dropDown.HoverBehavior.HoverOut();
                dropDown.AssertClosed();
            }
        }

        [WebTestMethod]
        public void Common_Click()
        {
            foreach (DropDownBehavior dropDown in DropDownBehaviors)
            {
                dropDown.HoverBehavior.HoverOver(); 
                DispatchEvent(dropDown.DropWrapper, HtmlEventName.Click);
                dropDown.AssertOpen(true);
                dropDown.HoverBehavior.HoverOut();
                DispatchEvent(dropDown.Element.ParentElement, HtmlEventName.Click);
                dropDown.AssertClosed();
            }
        }

        [WebTestMethod]
        public void Common_ClickClick()
        {
            foreach (DropDownBehavior dropDown in DropDownBehaviors)
            {
                dropDown.HoverBehavior.HoverOver();
                DispatchEvent(dropDown.DropWrapper, HtmlEventName.Click);
                dropDown.AssertOpen(true);
                DispatchEvent(dropDown.DropWrapper, HtmlEventName.Click);
                dropDown.HoverBehavior.HoverOut();
                dropDown.AssertClosed();
            }
        }

        [WebTestMethod]
        public void Common_ContextBody()
        {
            foreach (DropDownBehavior dropDown in DropDownBehaviors)
            {
                if (dropDown.SupportsContextMenu.Value)
                {
                    dropDown.HoverBehavior.HoverOver();
                    dropDown.DropWrapper.Reference.DispatchEvent(new HtmlEvent("ContextMenu"));
                    dropDown.AssertOpen(true);
                    dropDown.HoverBehavior.HoverOut();
                    dropDown.Element.ParentElement.ParentElement.DispatchEvent(new HtmlEvent("ContextMenu"));
                    dropDown.AssertClosed();
                }
            }
        }

        [WebTestMethod]
        public void Common_ContextControl()
        {
            foreach (DropDownBehavior dropDown in DropDownBehaviors)
            {
                if (dropDown.SupportsContextMenu.Value)
                {
                    dropDown.HoverBehavior.HoverOver();
                    dropDown.DropWrapper.Reference.DispatchEvent(new HtmlEvent("ContextMenu"));
                    dropDown.AssertOpen(true);
                    dropDown.HoverBehavior.HoverOut();
                    dropDown.DropDownControl.Reference.DispatchEvent(new HtmlEvent("ContextMenu"));
                    dropDown.AssertOpen(false);
                }
            }
        }

        protected static void DispatchEvent(HtmlElement element, HtmlEventName eventName)
        {
            Assert.IsNotNull(element);
            HtmlEvent @event;
            switch (eventName)
            {
                case HtmlEventName.MouseDown:
                case HtmlEventName.MouseMove:
                case HtmlEventName.MouseOut:
                case HtmlEventName.MouseOver:
                case HtmlEventName.MouseUp:
                case HtmlEventName.Click:
                case HtmlEventName.DoubleClick:
                    @event = new HtmlMouseEvent(eventName.ToString());
                    break;
                case HtmlEventName.KeyDown:
                case HtmlEventName.KeyPress:
                case HtmlEventName.KeyUp:
                    throw new ArgumentException(string.Format("DispatchEvent can not be used for key events like {0}.", eventName), "eventName");
                default:
                    @event = new HtmlEvent(eventName.ToString());
                    break;
            }
            element.DispatchEvent(@event);
        }
    }
}
