// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.CollapsiblePanel;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>CollapsiblePanel\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.CollapsiblePanelBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.CollapsiblePanel.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("CollapsiblePanel.Sample")]
[WebTestTag("SampleWebSite")]
public class CollapsiblePanel_Sample : CollapsiblePanel_Common
{
    public override IEnumerable<CollapsiblePanelBehavior> CollapsiblePanels
    {
        get { yield return (new SamplePage()).cpeDemo; }
    }

    public override bool SupportsPostback
    {
        get { return true; }
    }

    public override void DoPostback(CollapsiblePanelBehavior collapsiblePanel)
    {
        SamplePage page = collapsiblePanel.Page as SamplePage;
        Assert.IsNotNull(page, "collapsiblePanel.Page must be of type SamplePage!");

        page.LinkButton.Click(true);
        page.Invalidate();
    }
}
