// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// The ClientMemberType of a BehaviorProperty specifies how
    /// it is serialized to JavaScript during synchronization.
    /// </summary>
    public enum ClientMemberType
    {
        /// <summary>
        /// The BehaviorProperty refers to a client-side property and
        /// should be read using "behavior.get_Property()" and written
        /// using "behavior.set_Property(value)".
        /// </summary>
        Property = 0,

        /// <summary>
        /// The BehaviorProperty refers to a client-side field and
        /// should be read using "behavior.Property" and written
        /// using "behavior.Property = value".
        /// </summary>
        Field = 1,

        /// <summary>
        /// The BehviorProperty refers to an object on the client-side
        /// that must be read and written using custom JavaScript
        /// expressions.
        /// </summary>
        Custom = 2
    }
}