// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.AutoComplete;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>AutoComplete\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AutoCompleteBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.AutoComplete.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("AutoComplete.Sample")]
[WebTestTag("SampleWebSite")]
public class AutoComplete_Sample : AutoComplete_Common
{
    public override IEnumerable<AutoCompleteBehavior> AutoCompletes
    {
        get { yield return new SamplePage().AutoComplete; }
    }
}