// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Accordion;

/// <summary>
/// Databound Accordion tests
/// </summary>
/// <TestSuite>
///   <Path>Accordion\Databound.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AccordionBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Accordion.DataboundPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Accordion.Databound")]
public class Accordion_Databound : AjaxControlToolkit.Testing.Client.Accordion.Accordion_Common
{
    /// <summary>
    /// Accordion behaviors on the page along with the number of panes in
    /// each Accordion and a button used to cause a postback or partial
    /// postback
    /// </summary>
    public override IEnumerable<AccordionScenario> AccordionScenarios
    {
        get
        {
            DataboundPage page = new DataboundPage();
            yield return new AccordionScenario(page.Accordion, 4, page.Postback);
        }
    }
}