// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.Accordion
{
    /// <summary>
    /// Details necessary for common Accordion tests
    /// </summary>
    public class AccordionScenario
    {
        /// <summary>
        /// Accordion behavior
        /// </summary>
        public AccordionBehavior Accordion
        {
            get { return _accordion; }
        }
        private AccordionBehavior _accordion;

        /// <summary>
        /// Expected number of Accordion panes
        /// </summary>
        public int ExpectedCount
        {
            get { return _expectedCount; }
        }
        private int _expectedCount;

        /// <summary>
        /// Button used to cause a postback
        /// </summary>
        public HtmlInputElement PostBack
        {
            get { return _postback; }
        }
        private HtmlInputElement _postback;

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="accordion">Accordion behavior</param>
        /// <param name="expectedCount">Expected number of Accordion panes</param>
        /// <param name="postback">Button used to cause a postback</param>
        public AccordionScenario(AccordionBehavior accordion, int expectedCount, HtmlInputElement postback)
        {
            Assert.IsNotNull(accordion);
            _accordion = accordion;
            Assert.IsTrue(expectedCount >= 0, "Expected count should be greater than or equal to 0, not {0}!", expectedCount);
            _expectedCount = expectedCount;
            _postback = postback;
        }
    }
}