<%@ Page
    Language="C#"
    CodeFile="Sample.aspx.cs"
    Inherits="AjaxControlToolkit.Testing.Client.AlwaysVisibleControl.Sample" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>AlwaysVisibleControl - Sample</title>
    <link href="../StyleSheet.css" rel="stylesheet" type="text/css" />
</head>
<body><form id="form" runat="server"><div>
    <b>AlwaysVisibleControl - Sample</b><br />
    SampleWebSite scenario<br /><br /><br />
    
    <ajaxToolkit:ToolkitScriptManager ID="ScriptManager" runat="server" />
    
    <asp:UpdatePanel runat="server" ID="UpdatePanel1" >
        <ContentTemplate>
            <div style="width:230px;height:100px">
                <asp:Panel ID="timer" runat="server"
                    Width="250px" BackColor="White" ForeColor="DarkBlue"
                    BorderWidth="2" BorderStyle="solid" BorderColor="DarkBlue" style="z-index: 1;">
                        <div style="width: 100%; height: 100%; vertical-align: middle; text-align: center;">
                            <p>Current Time:</p>
                            <span id="currentTime" runat="server" style="font-size:xx-large;font-weight:bold;line-height:40px;"/>
                        </div>
                </asp:Panel>
                <ajaxToolkit:AlwaysVisibleControlExtender ID="avce" runat="server"
                    TargetControlID="timer"
                    VerticalSide="Top"
                    VerticalOffset="10"
                    HorizontalSide="Right"
                    HorizontalOffset="10"
                    ScrollEffectDuration=".1" />
            </div>
            <p>
                Choose a position for the clock from the list below. Scroll your browser window to see
                the control maintain its always-visible position.  
            </p>
            <p>
                Position: <asp:DropDownList ID="ddlPosition" runat="server" 
                    AutoPostBack="true" OnSelectedIndexChanged="OnChange">
                    <asp:ListItem Text="Default" Selected="true"  Value="None" />
                    <asp:ListItem Text="Top Left" Value="TL" />
                    <asp:ListItem Text="Top Center" Value="TC" />
                    <asp:ListItem Text="Top Right"  Value="TR" />
                    <asp:ListItem Text="Middle Left" Value="ML" />
                    <asp:ListItem Text="Middle Center" Value="MC" />
                    <asp:ListItem Text="Middle Right"  Value="MR" />
                    <asp:ListItem Text="Bottom Left" Value="BL" />
                    <asp:ListItem Text="Bottom Center" Value="BC" />
                    <asp:ListItem Text="Bottom Right" Value="BR" />
                </asp:DropDownList>
            </p>
        </ContentTemplate>
     </asp:UpdatePanel>
     
     <script type="text/javascript" language="javascript">
        function updateTime()
        {
            var label = document.getElementById('currentTime');
            if (label) {
                var time = (new Date()).localeFormat("T");
                label.innerHTML = time;
            }
        }
        updateTime();
        window.setInterval(updateTime, 1000);
    </script>
</div></form></body>
</html>