<%@ Page Language="C#" MasterPageFile="~/DefaultMaster.master" AutoEventWireup="true"
    Inherits="CommonPage" Title="ASP.NET AJAX Control Toolkit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="SampleContent" runat="Server">
 <div class="heading">ASP.NET AJAX Control Toolkit</div>
       <p>
Welcome to the ASP.NET AJAX Control Toolkit.
   </p>
    <br />
    <p>
Choose from any of the samples on the left to see the live controls in action, and experiment with their different possibilities. 
   </p>
 <div class="subheading">What is the ASP.NET AJAX Control Toolkit?</div>
   <p>
 The ASP.NET AJAX Control Toolkit is an open-source project built on top of the Microsoft ASP.NET AJAX framework. 
It is a joint effort between Microsoft and the ASP.NET AJAX community that provides a powerful infrastructure to write reusable, 
customizable and extensible ASP.NET AJAX extenders and controls, as well as a rich array of controls that 
can be used out of the box to create an interactive Web experience.
   </p>
    <br />
    <p>
The AJAX Control Toolkit contains more than 30 controls that enable you to easily create rich, interactive web pages. 
   </p>
    <br />
    <p>
To get started, and to install the Ajax Control Toolkit, visit the        
<a href="http://www.codeplex.com/Wiki/View.aspx?ProjectName=AtlasControlToolkit">AJAX Control Toolkit Project Page</a>
on CodePlex. 
   </p>
    <br />
    <p>
To learn more, read the <a href="http://www.asp.net/learn/Ajax-Control-Toolkit/tutorial-47-cs.aspx">Getting Started Tutorial</a>, or the other walkthroughs, tutorials and videos shown on the left.
    </p>
    <br />
    <p>

        <strong><u>AJAX Control Toolkit Release Notes - May 2009 Release</u></strong><br />
        <strong><u>Version 3.0.30512 </u></strong></p>
    <br />
    <strong><u>New controls</u></strong>
    <p>
        This release includes three important new controls:
    </p>
    <ul class="releaseList">
        <li><strong><a href="HTMLEditor/HTMLEditor.aspx">HTMLEditor</a></strong>
            <p>The HTMLEditor control allows you to easily create and edit HTML content. You can edit in design mode, as a rich text editor, or in source view to edit the HTML markup directly.</p>
            <p>Many thanks to by Obout <a href="http://www.obout.com">http://www.obout.com</a> for building this.</p></li>
        <li><strong><a href="ComboBox/ComboBox.aspx">ComboBox</a></strong>
            <p>The ComboBox control provides a DropDownList of items, combined with TextBox. Different modes determine the interplay between the text entry and the list of items.</p>
            <p>Many thanks to Dan Ludwig for building this.</p></li>
        <li><strong><a href="ColorPicker/ColorPicker.aspx">ColorPicker</a></strong>
            <p>The ColorPicker Control Extender can be attached to any ASP.NET TextBox control. It provides client-side color-picking functionality with UI in a popup control.</p>
            <p>Many thanks to Alexander Turlov for building this.</p></li>
    </ul>
    <br />
    <strong><u>Community effort</u></strong>
    <p>
        More than twenty important bug fixes have been made in this release, across many controls, corresponding to some of the most requested fixes.
    </p>
    <br />
    <p>
        We would like to specially thank all the <a href="http://www.codeplex.com/AtlasControlToolkit/Wiki/View.aspx?title=PatchUtility">
            patch </a> contributors from the Toolkit community whose fixes helped make
        this release possible. We recognize their names on the <a href="http://www.codeplex.com/AtlasControlToolkit/Wiki/View.aspx?title=PatchHallOfFame">
            Toolkit Patch Hall of Fame</a>.
    </p>
    <br />
        <p><strong><u>New tutorials</u></strong> have been created, with improved integration in the <a href="http://www.asp.net/ajax">ASP.NET AJAX Web site</a>.</p>
        <br />
        <p>The <strong><u>TemplateVSI project</u></strong>  has been removed. See the new tutorial: <a href="http://www.asp.net/learn/Ajax-Control-Toolkit/tutorial-49-cs.aspx">Creating a New Extender</a> for information on how to create an Extender, without needing a Visual Studio Extender project template.</p>
        <br />
        <p>
        <strong><u>Note:</u></strong> This May 2009 release: <strong>Toolkit version 3.0.30512</strong> is <em>only</em>
        for users who are building on top of <strong>.NET Framework 3.5 using Visual Studio 2008</strong>.
    <br />
      If you are using <strong>.NET Framework 2.0 and Visual Studio 2005</strong> then you should use the 
            earlier <strong>Toolkit version 1.0.20229</strong>.</p>
    <br />
    Link to Toolkit Release <a href="ArchivedReleases.aspx">archive</a>.</asp:Content>
