// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.TextboxWatermark
{
    /// <summary>
    /// Core tests for TextboxWatermark
    /// </summary>
    public partial class Core : Page
    {
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            SetLabel("");
        }

        protected void Button_Click(object sender, EventArgs e)
        {
            SetLabel(TextBox.Text);
        }

        private void SetLabel(string text)
        {
            Label.Text = string.Format(":{0}:", text);
        }
    }
}
