// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.IO;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.Engine;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// Test Driver
    /// </summary>
    public partial class TestDriver : TestDriverPage
    {
        /// <summary>
        /// Example showing how to log the results of a test run
        /// </summary>
        static TestDriver()
        {
            // Process the test log provided by the TestExecutor.getLogContent function
            //TestcaseExecutor.TestRunFinished += new EventHandler<TestRunFinishedEventArgs>(
            //    delegate(object sender, TestRunFinishedEventArgs e)
            //    {
            //        try
            //        {
            //            const string LogPath = @"C:\ToolkitTestLogs";
            //            string file = Path.Combine(LogPath, string.Format(@"{0:yyyy-MM-dd HH-mm-ss-ffffff}.html", DateTime.Now));
            //            StringBuilder result = new StringBuilder(e.TestLog);
            //            bool alternate = true;
            //            result.Append("<br /><br /><table width='100%'>");
            //            foreach (KeyValuePair<string, string> pair in e.Details)
            //            {
            //                if (string.Compare("TestLog", pair.Key, StringComparison.OrdinalIgnoreCase) == 0)
            //                {
            //                    continue;
            //                }

            //                result.AppendFormat("<tr style=\"background-color: {2};\"><td>{0}</td><td>{1}</td></tr>",
            //                    pair.Key, pair.Value, alternate ? "#D0D0D0" : "#FFFFFF");
            //                alternate = !alternate;
            //            }
            //            result.Append("</table>");
                        
            //            File.WriteAllText(file, result.ToString());
            //        }
            //        catch
            //        {
            //        }
            //    });
        }

        /// <summary>
        /// Prevent the test driver page from auto-generating the UI
        /// </summary>
        /// <param name="e">EventArgs</param>
        protected override void OnInit(EventArgs e)
        {
            // Set various UI components before the base class creates them
            AutoGenerateInterface = false;
            PageScriptManager = ScriptManager;
            TestCases = treeTestCases;
            ThreadId = lblThread;

            base.OnInit(e);
        }

        /// <summary>
        /// Auto-select tests with a given tag and/or auto-run selected tests
        /// </summary>
        /// <param name="e">EventArgs</param>
        protected override void OnLoadComplete(EventArgs e)
        {
            base.OnLoadComplete(e);

            // Only auto-select or auto-run on the first request
            if (!IsPostBack)
            {
                // Get query string values
                string tag;
                bool run, hasTag, filter, skipfail, syncLogs;
                WebTestLogDetail logDetail;
                ProcessQueryString(Request.QueryString, out run, out hasTag, out tag, out filter, out skipfail, out logDetail, out syncLogs);
                Browsers browser = BrowserUtility.GetBrowser(this);

                LogDetail = logDetail;

                // Auto-select tests with a given tag
                if (hasTag)
                {
                    TestCaseManager.SelectTaggedTests(treeTestCases, tag, browser);
                }
                else if (run)
                {
                    TestCaseManager.SelectAllTests(treeTestCases, browser);
                }

                // Optionally remove unselected tests
                if (filter)
                {
                    TestCaseManager.FilterIgnoredTests(treeTestCases);
                }

                // Auto-run the selected tests (or all tests if none are selected)
                if (run)
                {
                    btnRun.Enabled = false;
                    RunTestCases();
                }
            }
        }

        /// <summary>
        /// Run the tests when the button is clicked
        /// </summary>
        protected void btnRun_Click(object sender, EventArgs e)
        {
            if (chkSkipFail.Checked)
            {
                TestCaseManager.IgnoreFailures(treeTestCases, BrowserUtility.GetBrowser(this));
            }

            if (chkFilter.Checked)
            {
                TestCaseManager.FilterIgnoredTests(treeTestCases);
            }

            LogDetail = (WebTestLogDetail) cmbVerbosity.SelectedIndex;

            RunTestCases();
        }

        /// <summary>
        /// Process the page's QueryString to determine the execution's parameters
        /// </summary>
        /// <param name="querystring">QueryString</param>
        /// <param name="run">Whether the tests should be automatically run</param>
        /// <param name="hasTag">Whether the query string included a tag</param>
        /// <param name="tag">Tag of the tests to run</param>
        /// <param name="filter">Whether the list of tests should be filtered</param>
        /// <param name="skipfail">Whether the list of tests should be filtered for failures</param>
        /// <param name="logDetail">Amount of detail required by the log</param>
        /// <param name="syncLogs">True if display of the logs should be updated as they proceed</param>
        public static void ProcessQueryString(NameValueCollection querystring, out bool run, out bool hasTag, out string tag, out bool filter, out bool skipfail, out WebTestLogDetail logDetail, out bool syncLogs)
        {
            tag = querystring["tag"];
            hasTag = !string.IsNullOrEmpty(tag);

            run = false;
            bool.TryParse(querystring["run"], out run);

            filter = false;
            bool.TryParse(querystring["filter"], out filter);

            skipfail = false;
            if (bool.TryParse(querystring["skipfail"], out skipfail) && skipfail)
            {
                tag = hasTag ?
                    string.Format("({0})-Fail", tag) :
                    "!Fail";
                hasTag = true;
            }

            logDetail = WebTestLogDetail.Default;

            bool concise = false;
            if (bool.TryParse(querystring["concise"], out concise) && concise)
            {
                logDetail = WebTestLogDetail.Concise;
            }

            bool verbose = false;
            if (bool.TryParse(querystring["verbose"], out verbose) && verbose)
            {
                logDetail = WebTestLogDetail.Verbose;
            }

            syncLogs = false;
            bool.TryParse(querystring["synclogs"], out syncLogs);
        }
    }
}