// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.ReorderList
{
    /// <summary>
    /// ReorderList bounds to an IListDataSource
    /// </summary>
    public partial class IListDataSource : Page
    {
        /// <summary>
        /// DataSource to bind to
        /// </summary>
        protected object ListDataSource
        {
            get
            {
                IList<Person> people = ViewState["IList"] as IList<Person>;
                if (people == null)
                {
                    people = new List<Person>();
                    people.Add(new Person("Shawn", 3116));
                    people.Add(new Person("David", 3114));
                    people.Add(new Person("Kirti", 3115));
                    people.Add(new Person("Ted", 3115));
                    ViewState["IList"] = people;
                }
                return people;
            }
        }

        /// <summary>
        /// Bind the data source
        /// </summary>
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            if (!IsPostBack)
            {
                List.DataSource = ListDataSource;
                List.DataBind();
            }
        }
    }

    /// <summary>
    /// Person class used to fill the list
    /// </summary>
    [Serializable]
    public class Person
    {
        /// <summary>
        /// Name of the person
        /// </summary>
        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }
        private string _name;

        /// <summary>
        /// Office of the person
        /// </summary>
        public int Office
        {
            get { return _office; }
            set { _office = value; }
        }
        private int _office;

        /// <summary>
        /// Default constructor
        /// </summary>
        public Person()
            : this(null, 0)
        {
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="name">Name</param>
        /// <param name="office">Office</param>
        public Person(string name, int office)
        {
            _name = name;
            _office = office;
        }

        /// <summary>
        /// Convert the person's name and office into a string
        /// </summary>
        /// <returns>String</returns>
        public override string ToString()
        {
            return string.Format("{0}, {1}", _name, _office);
        }
    }
}