// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.ModalPopup
{
    /// <summary>
    /// Show and hide the ModalPopup programmatically from the client and server side.
    /// </summary>
    public partial class ProgrammaticShowHide : Page
    {
        protected void ShowViaServer_Click(object sender, EventArgs e)
        {
            ModalPopupExtender1.Show();
        }
        protected void HideViaServer_Click(object sender, EventArgs e)
        {
            ModalPopupExtender1.Hide();
        }

        protected void MultipleShowsViaServer_Click(object sender, EventArgs e)
        {
            // Multiple calls to "Show()" or "hide()" should work
            ModalPopupExtender1.Show();
            ModalPopupExtender1.Show();
            ModalPopupExtender1.Show();
        }
    }
}