<%@ Page Language="C#" CodeFile="ZeroMinimumPrefixLength.aspx.cs" Inherits="AjaxControlToolkit.Testing.Client.AutoComplete.ZeroMinimumPrefixLength" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>AutoComplete - ZeroMinimumPrefixLength</title>
</head>
<body>
    <form id="form" runat="server">
        <div>

            <script runat="server">
                [System.Web.Services.WebMethod]
                [System.Web.Script.Services.ScriptMethod]
                public static string[] GetResults(string prefixText, int count)
                {
                    if (count == 0)
                    {
                        count = 10;
                    }

                    if (prefixText.Equals("xyz"))
                    {
                        return new string[0];
                    }

                    ArrayList items = new ArrayList(count);
                    Random random = new Random();
                    for (int i = 0; i < count; i++)
                    {
                        char c1 = (char)random.Next(65, 90);
                        char c2 = (char)random.Next(97, 122);
                        char c3 = (char)random.Next(97, 122);

                        items.Add(prefixText + c1 + c2 + c3);
                    }

                    return (string[])items.ToArray(typeof(string));
                }
            </script>

            <b>AutoComplete - ZeroMinimumPrefixLength</b><br />
            Make sure that autocomplete timer works right and gets results when the minimum
            prefix length is zero.<br />
            <br />
            <br />
            <ajaxToolkit:ToolkitScriptManager ID="ScriptManager" runat="server" />
            <asp:TextBox ID="autoCompleteTextBox" runat="server"></asp:TextBox>
            <ajaxToolkit:AutoCompleteExtender ID="autoComplete" runat="Server" TargetControlID="autoCompleteTextBox"
                MinimumPrefixLength="0" ServiceMethod="GetResults">
            </ajaxToolkit:AutoCompleteExtender>
        </div>
    </form>
</body>
</html>
