<%@ Page Language="C#" CodeFile="ContextKey.aspx.cs" Inherits="AjaxControlToolkit.Testing.Client.AutoComplete.ContextKey" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>AutoComplete - ContextKey</title>
    <style type="text/css">
    /*AutoComplete flyout */

.autocomplete_completionListElement 
{  
	visibility : hidden;
	margin : 0px!important;
	background-color : inherit;
	color : windowtext;
	border : buttonshadow;
	border-width : 1px;
	border-style : solid;
	cursor : 'default';
	overflow : auto;
	height : 200px;
    text-align : left; 
    list-style-type : none;
}

/* AutoComplete highlighted item */

.autocomplete_highlightedListItem
{
	background-color: #ffff99;
	color: black;
	padding: 1px;
}

/* AutoComplete item */

.autocomplete_listItem 
{
	background-color : window;
	color : windowtext;
	padding : 1px;
}
    </style>    
</head>
<body>
    <form id="form" runat="server">
        <div>
            <b>AutoComplete - ContextKey</b><br />
            Make sure that ContextKey is passed correctly to the AutoComplete webservice<br />
            <br />
            <br />
            <ajaxToolkit:ToolkitScriptManager ID="ScriptManager" runat="server" />

            <script runat="server">
                [System.Web.Services.WebMethod]
                [System.Web.Script.Services.ScriptMethod]
                public static string[] GetCompletionListWithContext(string prefixText, int count, string contextKey)
                {
                    if (count == 0)
                    {
                        count = 10;
                    }

                    if (prefixText.Equals("xyz"))
                    {
                        return new string[0];
                    }

                    ArrayList items = new ArrayList(count);
                    Random random = new Random();
                    for (int i = 0; i < count; i++)
                    {
                        char c1 = (char)random.Next(65, 90);
                        char c2 = (char)random.Next(97, 122);
                        char c3 = (char)random.Next(97, 122);

                        items.Add(prefixText + c1 + c2 + c3 + contextKey);
                    }

                    return (string[])items.ToArray(typeof(string));
                }

            </script>

            <br />
            <br />
            <asp:TextBox ID="TextBox2" runat="server"></asp:TextBox>
            <ajaxToolkit:AutoCompleteExtender ID="AutoCompleteExtender2" runat="server" TargetControlID="TextBox2"
                ServiceMethod="GetCompletionListWithContext" UseContextKey="true" MinimumPrefixLength="2"
                EnableCaching="false" CompletionSetCount="10" CompletionInterval="2000" BehaviorID="autoCompleteBehavior2"
                FirstRowSelected="true" DelimiterCharacters=";," ContextKey="Foo" CompletionListCssClass="autocomplete_completionListElement"
                CompletionListItemCssClass="autocomplete_listItem" CompletionListHighlightedItemCssClass="autocomplete_highlightedListItem" />
            <br />
            <br />
        </div>
    </form>
</body>
</html>
