// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ValidatorCallout;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>ValidatorCallout\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ValidatorCalloutBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ValidatorCallout.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ValidatorCallout.Sample")]
[WebTestTag("SampleWebSite")]
public class ValidatorCallout_Sample : AjaxControlToolkit.Testing.Client.ValidatorCallout.ValidatorCallout_Common
{

    public override IEnumerable<ValidatorCalloutScenario> ValidatorCalloutScenarios
    {
        get
        {
            SamplePage page = new SamplePage();
            page.PhoneNumberTextBox.SetText("123-456-7890");
            yield return new ValidatorCalloutScenario(
                    page.NReqE,
                    page.NameTextBox,
                    "",
                    "Joe Smith",
                    page.Button1,
                    false,
                    false);
            page.NameTextBox.SetText("Joe Smith");
            yield return new ValidatorCalloutScenario(
                    page.PNReqE,
                    page.PhoneNumberTextBox,
                    "",
                    "123-456-7890",
                    page.Button1,
                    false,
                    false);
            page.NameTextBox.SetText("Joe Smith");
            page.PhoneNumberTextBox.SetText("");
            yield return new ValidatorCalloutScenario(
                    page.PNReqEx,
                    page.PhoneNumberTextBox,
                    "2222",
                    "123-456-7890",
                    page.Button1,
                    false,
                    false);
        }
    }
}