// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Drawing;
using System.Text.RegularExpressions;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.UpdatePanelAnimation;

/// <summary>
/// SampleWebsite demo
/// </summary>
/// <TestSuite>
///   <Path>UpdatePanelAnimation\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.UpdatePanelAnimationBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.UpdatePanelAnimation.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("UpdatePanelAnimation.Sample")]
[WebTestTag("SampleWebSite")]
public class UpdatePanelAnimation_Sample : AjaxControlToolkit.Testing.Client.UpdatePanelAnimation.UpdatePanelAnimation_Common
{
    [WebTestMethod]
    public void PanelPropertiesOnAnimation()
    {
        SamplePage page = new SamplePage();

        page.upae.OnUpdating.Ended.Register();
        page.upae.OnUpdated.Ended.Register();

        page.btnUpdate.Click();
        page.upae.OnUpdating.Ended.Wait(10);

        Assert.IsTrue(Common.ConvertJsonValue<bool>(page.ExecuteScript("isValidStateOnUpdatingEnded")));
        string onUpdatingColor = Common.ConvertJsonValue<string>(page.ExecuteScript("colorOnUpdatingEnded"));
        UpdatePanelAnimation_Sample.CompareColors(Color.FromArgb(255, 255, 0, 0), UpdatePanelAnimation_Sample.ConvertToRgbIntegerReprensentations(onUpdatingColor));
        
        page.upae.OnUpdated.Ended.Wait(5);

        Assert.IsTrue(Common.ConvertJsonValue<bool>(page.ExecuteScript("isValidStateOnUpdatedEnded")));
        string onUpdatedColor = Common.ConvertJsonValue<string>(page.ExecuteScript("colorOnUpdatedEnded"));
        UpdatePanelAnimation_Sample.CompareColors(Color.FromArgb(255, 64, 102, 154), UpdatePanelAnimation_Sample.ConvertToRgbIntegerReprensentations(onUpdatedColor));
    }

    private static Color ConvertToRgbIntegerReprensentations(string colorRgbString)
    {
        // rgb(64, 102, 154)
        Regex colorRegex = new System.Text.RegularExpressions.Regex(@"rgb\((\d{1,3}), (\d{1,3}), (\d{1,3})\)");
        Match match = colorRegex.Match(colorRgbString);
        if(match.Success)
        {
            int red = Int32.Parse(match.Groups[1].Value);
            int green = Int32.Parse(match.Groups[2].Value); ;
            int blue = Int32.Parse(match.Groups[3].Value); ;
            return Color.FromArgb(255, red, green, blue);
        }
        else
        {
            WebColorConverter converter = new WebColorConverter();
            return (Color)converter.ConvertFrom(colorRgbString);
        }
    }

    private static void CompareColors(Color expected, Color actual)
    {
        Assert.AreEqual(expected.R, actual.R);
        Assert.AreEqual(expected.G, actual.G);
        Assert.AreEqual(expected.B, actual.B);
    }
}