// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.ToggleButtonExtender Model
    /// </summary>
    /// <TestComponent Name="ToggleButton">
    ///   <ToolkitType>AjaxControlToolkit.ToggleButtonExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.ToggleButton.ToggleButton_Common</CommonTestSuite>
    /// </TestComponent>
    public class ToggleButtonBehavior : Behavior<HtmlInputElement>
    {
        /// <summary>
        /// ImageWidth
        /// </summary>
        public BehaviorProperty<int> ImageWidth
        {
            get { return _imageWidth; }
        }
        private BehaviorProperty<int> _imageWidth;

        
        /// <summary>
        /// Decoy Element that contains the toggle button image as its background
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> DecoyElement
        {
            get { return _decoyElement; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _decoyElement;

        /// <summary>
        /// ImageHeight
        /// </summary>
        public BehaviorProperty<int> ImageHeight
        {
            get { return _imageHeight; }
        }
        private BehaviorProperty<int> _imageHeight;

        /// <summary>
        /// UncheckedImageUrl
        /// </summary>
        public BehaviorProperty<string> UncheckedImageUrl
        {
            get { return _uncheckedImageUrl; }
        }
        private BehaviorProperty<string> _uncheckedImageUrl;

        /// <summary>
        /// CheckedImageUrl
        /// </summary>
        public BehaviorProperty<string> CheckedImageUrl
        {
            get { return _checkedImageUrl; }
        }
        private BehaviorProperty<string> _checkedImageUrl;

        /// <summary>
        /// DisabledUncheckedImageUrl
        /// </summary>
        public BehaviorProperty<string> DisabledUncheckedImageUrl
        {
            get { return _disabledUncheckedImageUrl; }
        }
        private BehaviorProperty<string> _disabledUncheckedImageUrl;

        /// <summary>
        /// DisabledCheckedImageUrl
        /// </summary>
        public BehaviorProperty<string> DisabledCheckedImageUrl
        {
            get { return _disabledCheckedImageUrl; }
        }
        private BehaviorProperty<string> _disabledCheckedImageUrl;

        /// <summary>
        /// UncheckedImageAlternateText
        /// </summary>
        public BehaviorProperty<string> UncheckedImageAlternateText
        {
            get { return _uncheckedImageAlternateText; }
        }
        private BehaviorProperty<string> _uncheckedImageAlternateText;

        /// <summary>
        /// CheckedImageAlternateText
        /// </summary>
        public BehaviorProperty<string> CheckedImageAlternateText
        {
            get { return _checkedImageAlternateText; }
        }
        private BehaviorProperty<string> _checkedImageAlternateText;

        /// <summary>
        /// AjaxControlToolkit.ToggleButtonExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public ToggleButtonBehavior(HtmlInputElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _imageWidth = BehaviorProperty<int>.CreateProperty(this, "ImageWidth");
            _imageHeight = BehaviorProperty<int>.CreateProperty(this, "ImageHeight");
            _decoyElement = ReferenceBehaviorProperty<HtmlElement>.CreateField(this, "id", "{0}._decoyElement");
            _uncheckedImageUrl = BehaviorProperty<string>.CreateProperty(this, "UncheckedImageUrl");
            _checkedImageUrl = BehaviorProperty<string>.CreateProperty(this, "CheckedImageUrl");
            _disabledUncheckedImageUrl = BehaviorProperty<string>.CreateProperty(this, "DisabledUncheckedImageUrl");
            _disabledCheckedImageUrl = BehaviorProperty<string>.CreateProperty(this, "DisabledCheckedImageUrl");
            _uncheckedImageAlternateText = BehaviorProperty<string>.CreateProperty(this, "UncheckedImageAlternateText");
            _checkedImageAlternateText = BehaviorProperty<string>.CreateProperty(this, "CheckedImageAlternateText");
        }

        public void Toggle()
        {
            this.Element.Click(false);
            // Sleep for 50 ms to ensure that the checkbox is clicked and
            // its value is toggled. If no wait is performed the IsCHecked code
            // is called right away and cases intermittent failures in Firefox.
            System.Threading.Thread.Sleep(50);
        }

        public bool IsChecked()
        {
            string backgroundImage = this.DecoyElement.Reference.GetAttributes().Style.Get<string>("backgroundImage");
            
            if (this.Element.GetAttributes().Checked != null)
            {
                Assert.StringContains(backgroundImage, this.CheckedImageUrl.Value.ToLowerInvariant());
                return true;
            }
            else
            {
                Assert.StringContains(backgroundImage, this.UncheckedImageUrl.Value.ToLowerInvariant());
                return false;
            }
        }

        public void AssertToggleButtonHeight()
        {
            Assert.AreEqual(this.DecoyElement.Reference.GetAttributes().Style.Get<string>("height"), this.ImageHeight.Value + "px");
        }

        public void AssertToggleButtonWidth()
        {
            Assert.AreEqual(this.DecoyElement.Reference.GetAttributes().Style.Get<string>("width"), this.ImageWidth.Value + "px");
        }
    }
}