// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.ToggleButton
{
    /// <summary>
    /// Common ToggleButton tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.ToggleButtonBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("ToggleButton")]
    public abstract class ToggleButton_Common
    {
        public abstract IEnumerable<ToggleButtonBehavior> ToggleButtons
        {
            get;
        }

        [WebTestMethod]
        public void Common_ValidateStyle()
        {
            foreach (ToggleButtonBehavior toggleButton in ToggleButtons)
            {
                ToolkitAssert.All(
                    delegate() { toggleButton.AssertToggleButtonHeight(); },
                    delegate() { toggleButton.AssertToggleButtonWidth(); });
            }
        }

        [WebTestMethod]
        [WebTestTag("Smoke")]
        [WebTestFailureTag(Browsers.Opera | Browsers.Safari, "backgroundImage is not returned by test framework on Opera.")]
        public void Common_Toggle()
        {
            foreach (ToggleButtonBehavior toggleButton in ToggleButtons)
            {
                // toggle twice to verify checked/unchecked states and restore it to 
                // its original state
                this.PreventPostBack(toggleButton);
                bool originalState = toggleButton.IsChecked();
                toggleButton.Toggle();
                Assert.AreNotEqual(originalState, toggleButton.IsChecked());
                toggleButton.Toggle();
                Assert.AreEqual(originalState, toggleButton.IsChecked());
            }
        }

        private void PreventPostBack(ToggleButtonBehavior toggleButton)
        {

              string script = "(function() { " +
                "var e = $get('" + toggleButton.Element.Id + "'); " +
                "if (!e) { throw 'Failed to find element \"" + toggleButton.Element.Id + "\"!'; }; " +
                "e.onclick = '';" +
                "return true; " +
                "})()";
              toggleButton.Page.ExecuteScript(script);
        }
    }
}