// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.SlideShow;

/// <summary>
/// SlideShow test to make sure that having just one image does not break the SlideShow
/// </summary>
/// <TestSuite>
///   <Path>SlideShow\OnePicture.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.SlideShowBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.SlideShow.OnePicturePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("SlideShow.OnePicture")]
public class SlideShow_OnePicture : AjaxControlToolkit.Testing.Client.SlideShow.SlideShow_Common
{

    [WebTestMethod]
    public void ValidateOnePicture()
    {
        OnePicturePage page = new OnePicturePage();
        page.SlideShowExtender1.AssertSlideUrl("Sunset.jpg");
        // could make the test richer by adding next/prev buttons and making sure that they are disabled.
    }
}