// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ReorderList;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>ReorderList\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DropWatcherBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ReorderList.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ReorderList.Sample")]
[WebTestTag("SampleWebSite")]
public class ReorderList_Sample : ReorderList_Common
{
    public override IEnumerable<DropWatcherBehavior> ReorderLists
    {
        get { yield return (new SamplePage()).ReorderList1; }
    }
}
