// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.DraggableListItemBehavior Model
    /// </summary>
    // <TestComponent Name="DraggableListItem">
    // </TestComponent>
    public class DraggableListItemBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// DragHandle
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> DragHandle
        {
            get { return _dragHandle; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _dragHandle;

        /// <summary>
        /// Data
        /// </summary>
        public BehaviorProperty<string> Data
        {
            get { return _data; }
        }
        private BehaviorProperty<string> _data;

        /// <summary>
        /// AjaxControlToolkit.DraggableListItemBehavior Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public DraggableListItemBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _dragHandle = ReferenceBehaviorProperty<HtmlElement>.CreateField(this, "id", "{0}.get_handle()");
            _data = BehaviorProperty<string>.CreateProperty(this, "data");
        }
    }
}