// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// ReadStrategy defines how BehaviorProperty instances are
    /// synchronized with their corresponding client-side behaviors
    /// and cache the values they return
    /// </summary>
    [Flags]
    public enum ReadStrategy
    {
        /// <summary>
        /// Retrieve the value of the property when needed by
        /// forcing a synchronization
        /// </summary>
        Demand = 1,

        /// <summary>
        /// Retrieve the value of the property during the first
        /// synchronization
        /// </summary>
        Initialize = 2,

        /// <summary>
        /// Retrieve the value of the property during the first
        /// synchronization and whenever the cached value is invalidated
        /// </summary>
        DemandAndInitialize = Demand | Initialize,

        /// <summary>
        /// Retrieve the value of the property during every synchronization
        /// </summary>
        Always = 4,

        /// <summary>
        /// Perform a synchronization whenever the property is accessed
        /// </summary>
        Volatile = 8,
    }
}