// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.Rating
{
    /// <summary>
    /// Common Rating tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.RatingBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("Rating")]
    public abstract class Rating_Common
    {
        public abstract IEnumerable<RatingBehavior> RatingControls
        {
            get;
        }

        [WebTestMethod]
        [WebTestTag("Stress")]
        public void Common_ValidateRatingClick()
        {
            foreach (RatingBehavior rating in RatingControls)
            {
                rating.AutoPostBack.Value = false;
                int maxRating = rating.MaxRating.Value;
                for (int i = 1; i <= maxRating; ++i)
                {
                    rating.ClickRating(i, false);
                }
            }
        }

        [WebTestMethod]
        [WebTestTag("Css")]
        public void Common_AssertInitialRatingState()
        {
            foreach (RatingBehavior rating in RatingControls)
            {
                rating.AssertStarsCss();
            }
        }
    }
}