// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Rating;

/// <summary>
/// Validate that rating callbacks work fine
/// </summary>
/// <TestSuite>
///   <Path>Rating\Callbacks.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.RatingBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Rating.CallbacksPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Rating.Callbacks")]
public class Rating_Callbacks : AjaxControlToolkit.Testing.Client.Rating.Rating_Common
{
    public override IEnumerable<RatingBehavior> RatingControls
    {
        get
        {
            yield return new CallbacksPage().Rating1_RatingExtender;
        }
    }

    [WebTestMethod]
    public void ValidateCallbackResult()
    {
        CallbacksPage page = new CallbacksPage();
        RatingBehavior rating = page.Rating1_RatingExtender;
        // check change event has not fired
        Assert.IsFalse(this.CheckChangeEventFired(page));
        // check callback has not occured
        Assert.IsFalse(this.CheckEventCallbackCompletedOK(page));
        
        // change the rating
        rating.ClickRating(rating.Rating.Value + 1, false);
        
        // check event
        Assert.IsTrue(this.CheckChangeEventFired(page));
        // check callback
        Assert.IsTrue(this.CheckEventCallbackCompletedOK(page));
        string callBackResult = this.GetCallBackResult(page);
        // the callback string contains "id;ratingvalue;tag".
        string[] resultSplit = callBackResult.Split(new char[] { ';' });
        Assert.AreEqual(3, resultSplit.Length);
        Assert.AreEqual(rating.Element.Id, resultSplit[0]);
        Assert.AreEqual(rating.Rating.Value.ToString(), resultSplit[1]);
        Assert.AreEqual(rating.Tag.Value, resultSplit[2]);
    }

    private string GetCallBackResult(CallbacksPage page)
    {
        return (string)page.ExecuteScript("_resultFromServerSide") ?? String.Empty;
    }

    private bool CheckEventCallbackCompletedOK(CallbacksPage page)
    {
        return Common.ConvertJsonValue<bool>(page.ExecuteScript("_eventCallBackOk"));
    }

    private bool CheckChangeEventFired(CallbacksPage page)
    {
        return Common.ConvertJsonValue<bool>(page.ExecuteScript("_eventOk"));
    }
    
}